/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class CurrentElm
extends CircuitElm {
    double currentValue;
    Polygon arrow;
    Point ashaft1;
    Point ashaft2;
    Point center;

    public CurrentElm(int n, int n2) {
        super(n, n2);
        this.currentValue = 0.01;
    }

    public CurrentElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        try {
            this.currentValue = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.currentValue = 0.01;
        }
    }

    String dump() {
        return super.dump() + " " + this.currentValue;
    }

    int getDumpType() {
        return 105;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(26);
        this.ashaft1 = this.interpPoint(this.lead1, this.lead2, 0.25);
        this.ashaft2 = this.interpPoint(this.lead1, this.lead2, 0.6);
        this.center = this.interpPoint(this.lead1, this.lead2, 0.5);
        Point point = this.interpPoint(this.lead1, this.lead2, 0.75);
        this.arrow = this.calcArrow(this.center, point, 4.0, 4.0);
    }

    void draw(Graphics graphics) {
        int n = 12;
        this.draw2Leads(graphics);
        this.setVoltageColor(graphics, (this.volts[0] + this.volts[1]) / 2.0);
        this.setPowerColor(graphics, false);
        CurrentElm.drawThickCircle(graphics, this.center.x, this.center.y, n);
        CurrentElm.drawThickLine(graphics, this.ashaft1, this.ashaft2);
        graphics.fillPolygon(this.arrow);
        this.setBbox(this.point1, this.point2, n);
        this.doDots(graphics);
        if (CurrentElm.sim.showValuesCheckItem.getState()) {
            String string = CurrentElm.getShortUnitText(this.currentValue, "A");
            if (this.dx == 0 || this.dy == 0) {
                this.drawValues(graphics, string, n);
            }
        }
        this.drawPosts(graphics);
    }

    void stamp() {
        this.current = this.currentValue;
        sim.stampCurrentSource(this.nodes[0], this.nodes[1], this.current);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Current (A)", this.currentValue, 0.0, 0.1);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        this.currentValue = editInfo.value;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "current source";
        this.getBasicInfo(stringArray);
    }

    double getVoltageDiff() {
        return this.volts[1] - this.volts[0];
    }
}

