/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class CounterElm
extends ChipElm {
    final int FLAG_ENABLE = 2;

    public CounterElm(int n, int n2) {
        super(n, n2);
    }

    public CounterElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    boolean needsBits() {
        return true;
    }

    String getChipName() {
        return "Counter";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = this.bits > 2 ? this.bits : 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(0, 2, "");
        this.pins[0].clock = true;
        this.pins[1] = new ChipElm.Pin(this.sizeY - 1, 2, "R");
        this.pins[1].bubble = true;
        for (int i = 0; i != this.bits; ++i) {
            int n = i + 2;
            this.pins[n] = new ChipElm.Pin(i, 3, "Q" + (this.bits - i - 1));
            this.pins[n].state = true;
            this.pins[n].output = true;
        }
        if (this.hasEnable()) {
            this.pins[this.bits + 2] = new ChipElm.Pin(this.sizeY - 2, 2, "En");
        }
        this.allocNodes();
    }

    int getPostCount() {
        if (this.hasEnable()) {
            return this.bits + 3;
        }
        return this.bits + 2;
    }

    boolean hasEnable() {
        return (this.flags & 2) != 0;
    }

    int getVoltageSourceCount() {
        return this.bits;
    }

    void execute() {
        int n;
        boolean bl = true;
        if (this.hasEnable()) {
            bl = this.pins[this.bits + 2].value;
        }
        if (this.pins[0].value && !this.lastClock && bl) {
            for (n = this.bits - 1; n >= 0; --n) {
                int n2 = n + 2;
                if (!this.pins[n2].value) {
                    this.pins[n2].value = true;
                    break;
                }
                this.pins[n2].value = false;
            }
        }
        if (!this.pins[1].value) {
            for (n = 0; n != this.bits; ++n) {
                this.pins[n + 2].value = false;
            }
        }
        this.lastClock = this.pins[0].value;
    }

    int getDumpType() {
        return 164;
    }
}

