/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class PhaseCompElm
extends ChipElm {
    boolean ff1;
    boolean ff2;

    public PhaseCompElm(int n, int n2) {
        super(n, n2);
    }

    public PhaseCompElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "phase comparator";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 2;
        this.pins = new ChipElm.Pin[3];
        this.pins[0] = new ChipElm.Pin(0, 2, "I1");
        this.pins[1] = new ChipElm.Pin(1, 2, "I2");
        this.pins[2] = new ChipElm.Pin(0, 3, "O");
        this.pins[2].output = true;
    }

    boolean nonLinear() {
        return true;
    }

    void stamp() {
        int n = PhaseCompElm.sim.nodeList.size() + this.pins[2].voltSource;
        sim.stampNonLinear(n);
        sim.stampNonLinear(0);
        sim.stampNonLinear(this.nodes[2]);
    }

    void doStep() {
        double d;
        boolean bl;
        boolean bl2 = this.volts[0] > 2.5;
        boolean bl3 = bl = this.volts[1] > 2.5;
        if (bl2 && !this.pins[0].value) {
            this.ff1 = true;
        }
        if (bl && !this.pins[1].value) {
            this.ff2 = true;
        }
        if (this.ff1 && this.ff2) {
            this.ff2 = false;
            this.ff1 = false;
        }
        double d2 = this.ff1 ? 5.0 : (d = this.ff2 ? 0.0 : -1.0);
        if (d != -1.0) {
            sim.stampVoltageSource(0, this.nodes[2], this.pins[2].voltSource, d);
        } else {
            int n = PhaseCompElm.sim.nodeList.size() + this.pins[2].voltSource;
            sim.stampMatrix(n, n, 1.0);
        }
        this.pins[0].value = bl2;
        this.pins[1].value = bl;
    }

    int getPostCount() {
        return 3;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    int getDumpType() {
        return 161;
    }
}

