/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Graphics;
import java.util.StringTokenizer;

class RailElm
extends VoltageElm {
    final int FLAG_CLOCK = 1;

    public RailElm(int n, int n2) {
        super(n, n2, 0);
    }

    RailElm(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public RailElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    int getDumpType() {
        return 82;
    }

    int getPostCount() {
        return 1;
    }

    void setPoints() {
        super.setPoints();
        this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 17.0 / this.dn);
    }

    void draw(Graphics graphics) {
        boolean bl;
        this.setBbox(this.point1, this.point2, 17.0);
        this.setVoltageColor(graphics, this.volts[0]);
        RailElm.drawThickLine(graphics, this.point1, this.lead1);
        boolean bl2 = bl = this.waveform == 2 && (this.flags & 1) != 0;
        if (this.waveform == 0 || this.waveform == 6 || bl) {
            Font font = new Font("SansSerif", 0, 12);
            graphics.setFont(font);
            graphics.setColor(this.needsHighlight() ? selectColor : whiteColor);
            this.setPowerColor(graphics, false);
            double d = this.getVoltage();
            String string = RailElm.getShortUnitText(d, "V");
            if (Math.abs(d) < 1.0) {
                string = showFormat.format(d) + "V";
            }
            if (this.getVoltage() > 0.0) {
                string = "+" + string;
            }
            if (this instanceof AntennaElm) {
                string = "Ant";
            }
            if (bl) {
                string = "CLK";
            }
            this.drawCenteredText(graphics, string, this.x2, this.y2, true);
        } else {
            this.drawWaveform(graphics, this.point2);
        }
        this.drawPosts(graphics);
        this.curcount = this.updateDotCount(-this.current, this.curcount);
        if (RailElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
        }
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    void stamp() {
        if (this.waveform == 0) {
            sim.stampVoltageSource(0, this.nodes[0], this.voltSource, this.getVoltage());
        } else {
            sim.stampVoltageSource(0, this.nodes[0], this.voltSource);
        }
    }

    void doStep() {
        if (this.waveform != 0) {
            sim.updateVoltageSource(0, this.nodes[0], this.voltSource, this.getVoltage());
        }
    }

    boolean hasGroundConnection(int n) {
        return true;
    }

    int getShortcut() {
        return 86;
    }
}

