/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

class TextElm
extends GraphicElm {
    String text;
    Vector<String> lines;
    int size;
    final int FLAG_CENTER = 1;
    final int FLAG_BAR = 2;

    public TextElm(int n, int n2) {
        super(n, n2);
        this.text = "hello";
        this.lines = new Vector();
        this.lines.add(this.text);
        this.size = 24;
    }

    public TextElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.size = new Integer(stringTokenizer.nextToken());
        this.text = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            this.text = this.text + ' ' + stringTokenizer.nextToken();
        }
        this.split();
    }

    void split() {
        this.lines = new Vector();
        StringBuffer stringBuffer = new StringBuffer(this.text);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\\') continue;
            stringBuffer.deleteCharAt(i);
            c = stringBuffer.charAt(i);
            if (c != 'n') continue;
            this.lines.add(stringBuffer.substring(0, i));
            stringBuffer.delete(0, i + 1);
            i = -1;
        }
        this.lines.add(stringBuffer.toString());
    }

    String dump() {
        return super.dump() + " " + this.size + " " + this.text;
    }

    int getDumpType() {
        return 120;
    }

    void drag(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.x2 = n + 16;
        this.y2 = n2;
    }

    void draw(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        Font font = new Font("SansSerif", 0, this.size);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = -1;
        for (n2 = 0; n2 != this.lines.size(); ++n2) {
            n = fontMetrics.stringWidth(this.lines.elementAt(n2));
            if (n <= n3) continue;
            n3 = n;
        }
        n = this.y;
        this.setBbox(this.x, this.y, this.x, this.y);
        for (n2 = 0; n2 != this.lines.size(); ++n2) {
            String string = this.lines.elementAt(n2);
            if ((this.flags & 1) != 0) {
                this.x = (TextElm.sim.winSize.width - fontMetrics.stringWidth(string)) / 2;
            }
            graphics.drawString(string, this.x, n);
            if ((this.flags & 2) != 0) {
                int n4 = n - fontMetrics.getAscent();
                graphics.drawLine(this.x, n4, this.x + fontMetrics.stringWidth(string) - 1, n4);
            }
            this.adjustBbox(this.x, n - fontMetrics.getAscent(), this.x + fontMetrics.stringWidth(string), n + fontMetrics.getDescent());
            n += fontMetrics.getHeight();
        }
        this.x2 = this.boundingBox.x + this.boundingBox.width;
        this.y2 = this.boundingBox.y + this.boundingBox.height;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("Text", 0.0, -1.0, -1.0);
            editInfo.text = this.text;
            return editInfo;
        }
        if (n == 1) {
            return new EditInfo("Size", this.size, 5.0, 100.0);
        }
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Center", (this.flags & 1) != 0);
            return editInfo;
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Draw Bar On Top", (this.flags & 2) != 0);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.text = editInfo.textf.getText();
            this.split();
        }
        if (n == 1) {
            this.size = (int)editInfo.value;
        }
        if (n == 3) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        }
        if (n == 2) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        }
    }

    boolean isCenteredText() {
        return (this.flags & 1) != 0;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = this.text;
    }

    int getShortcut() {
        return 116;
    }
}

